<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Superelevation Design Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis návrhu klopení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis návrhu klopenít</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="RoadwayDesigner">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@fileName"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není uvedeno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Section Data -->
                                <xsl:for-each select="SuperelevationSections/SuperelevationSection">
                                    <table class="margin" cellpadding="3" width="90%">
                                        <tbody>
                                            <tr>
                                                <th align="left" lang="en" width = "15%">Název sekce:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="left" lang="en">Název trasy:&#xa0; </th>
                                                <td align="left" colspan="2">
                                                    <xsl:value-of select="@baseHorizontal"/>
                                                </td>
                                            </tr>
                                            <xsl:if test="Standards">
                                                <tr>
                                                    <th align="left" lang="en">Název souboru směrnic:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@filename"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Návrhová rychlost:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@designSpeed"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th align="left" lang="en">Režim otáčen:&#xa0; </th>
                                                    <td align="left" colspan="2">
                                                        <xsl:value-of select="Standards/@pivotMethod"/>
                                                    </td>
                                                </tr>
                                                <xsl:if test=".//SuperelevationObject/@normalCrossSlope">
                                                    <tr>
                                                        <th align="left" lang="en">Sklon střechy:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="cif:gradeFormat(number(.//SuperelevationObject/@normalCrossSlope))"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@eSelection">
                                                    <tr>
                                                        <th align="left" lang="en">E výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@eSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <xsl:if test="Standards/@lSelection">
                                                    <tr>
                                                        <th align="left" lang="en">L výpočet:&#xa0; </th>
                                                        <td align="left" colspan="2">
                                                            <xsl:value-of select="Standards/@lSelection"/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:if>
                                        </tbody>
                                    </table>
                                    <xsl:choose>
                                        <xsl:when test=".//SuperelevationTransition">
                                            <xsl:for-each select="SuperelevationObjects/SuperelevationObject">
                                                <center>
                                                    <p lang="en" style="font-weight:bold">
                                                        <br/>Klopení:&#xa0; <xsl:value-of select="@name"/><br/>
                                                    </p>
                                                </center>
                                                <table class="margin" cellpadding="3" cellspacing="2" width="95%">
                                                    <thead style="display:table-header-group">
                                                        <tr>
                                                            <th class="underline" lang="en" align="center"><BR/><BR/>Motiv</th>
                                                            <th class="underline" lang="en" align="center"><BR/><BR/>Typ bodu</th>
                                                            <th class="underline" lang="en" align="center"><BR/>Staničení<BR/>[Definované]</th>
                                                            <th class="underline" lang="en" align="center"><BR/>Staničení<BR/>[Standardy]</th>
                                                            <th class="underline" lang="en" align="center"><BR/>Příčný sklon<BR/>[Definovaný]</th>
                                                            <th class="underline" lang="en" align="center"><BR/>Příčný sklon<BR/>[Standardy]</th>                                                            
                                                            <th class="underline" lang="en" align="center"><BR/><BR/>Poloměr</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <xsl:for-each select="SuperelevationTransitions/SuperelevationTransition">
                                                            <tr>
                                                                <td align="center">
                                                                    <xsl:value-of select="@curveSet"/>
                                                                </td>
                                                                <xsl:choose>
                                                                    <xsl:when test='@type = "FullSuper"'>
                                                                        <td align="center" lang="en">Plné klopení</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "FullSuperIn"'>
                                                                        <td align="center" lang="en">Plné klopení Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "FullSuperOut"'>
                                                                        <td align="center" lang="en">Plné klopení Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrown"'>
                                                                        <td align="center" lang="en">Střecha</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrownIn"'>
                                                                        <td align="center" lang="en">Střecha Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "NormalCrownOut"'>
                                                                        <td align="center" lang="en">Střecha Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrown"'>
                                                                        <td align="center" lang="en">Dostředný sklon</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrownIn"'>
                                                                        <td align="center" lang="en">Dostředný sklon Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "ReverseCrownOut"'>
                                                                        <td align="center" lang="en">Dostředný sklon Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoff"'>
                                                                        <td align="center" lang="en">Nulový sklon</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoffIn"'>
                                                                        <td align="center" lang="en">Nulový sklon Vstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "SuperRunoffOut"'>
                                                                        <td align="center" lang="en">Nulový sklon Výstup</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "StartPoint"'>
                                                                        <td align="center" lang="en">Počáteční bod</td>
                                                                    </xsl:when>
                                                                    <xsl:when test='@type = "EndPoint"'>
                                                                        <td align="center" lang="en">Koncový bod</td>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <td align="center" lang="en">Nedefinováno</td>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                <td align="center">
                                                                    <xsl:value-of select="cif:stationFormat(number(@externalStation), string(@externalStationName))"/>
                                                                </td>
                                                                <td align="center">
                                                                    <xsl:value-of select="cif:stationFormat(number(SuperelevationTransitionStandards/@externalStation), string(Original/@externalStationName))"/>
                                                                </td>
                                                                <td align="center">
                                                                    <xsl:value-of select="cif:gradeFormat(number(@crossSlope))"/>
                                                                </td>
                                                                <td align="center">
                                                                    <xsl:value-of select="cif:gradeFormat(number(SuperelevationTransitionStandards/@crossSlope))"/>
                                                                </td>                                                                
                                                                <td align="center">
                                                                <xsl:choose>
                                                                    <xsl:when test='@radius = "0"'>
                                                                        -- <!-- Print "0" radius values as dashes to indicate no radius -->
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                                </td>
                                                            </tr>
                                                        </xsl:for-each>
                                                    </tbody>
                                                </table>
                                                <br/>
                                            </xsl:for-each>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <center><p lang="en">Žádné klopení pro výpis.</p></center>
                                        </xsl:otherwise>
                                    </xsl:choose>                                      
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Musíte nejdříve definovat klopení sekce.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu sekci klopení.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>